/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import kr.floware.Ftil;
import kr.floware.concurrent.LockUtils;
import kr.floware.logging.Logger;
import kr.floware.socket.TcpLogListener;
import kr.floware.socket.TcpUtils;
import kr.floware.utils.Assert;
import kr.floware.utils.MemoryBuffer;

public class TcpConnector {
    private static Logger logger = Logger.getLogger();
    private static final int CONNECTING_TIME = 10000;
    private DataInputStream dis;
    private DataOutputStream dos;
    private String ipAddress = "127.0.0.1";
    private int port = 0;
    Socket socket;
    ServerSocket ss = null;

    public String getSckRemote() {
        return null == this.getSocket() ? "" : this.getSocket().getRemoteSocketAddress().toString();
    }

    public String getSckLocal() {
        return null == this.getSocket() ? "" : this.getSocket().getLocalSocketAddress().toString();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    private SocketAddress ipClient() {
        InetSocketAddress isa = new InetSocketAddress(this.getIpAddress(), this.getPort());
        return isa;
    }

    public boolean isConnected() {
        if (null == this.getSocket()) {
            return false;
        }
        return this.getSocket().isConnected() && !this.getSocket().isClosed() && !this.getSocket().isInputShutdown() && !this.getSocket().isOutputShutdown();
    }

    public Socket tryConnect() {
        return this.tryConnect(10000);
    }

    public Socket tryConnect(int ms) {
        this.assertNotContd();
        try {
            Socket sck = new Socket();
            logger.i("TCP %s CONNECTING", this.ipClient());
            sck.connect(this.ipClient(), ms);
            this.defSckOpt(sck);
            logger.i("TCP %s CONNECTED", this.getSckLocal());
            return sck;
        }
        catch (IOException e) {
            logger.i("TCP %s CONNECT ERROR %s", this.ipClient(), e.getMessage());
            LockUtils.quietWait(1000);
        }
        catch (Exception e) {
            logger.e(e);
        }
        return this.getSocket();
    }

    public Socket tryListen(TcpLogListener listener) {
        this.assertNotContd();
        try {
            this.ss = new ServerSocket(this.getPort());
            listener.onLog(Ftil.fff("TCP LISTENING %d", this.getPort()));
            Socket sck = this.ss.accept();
            this.defSckOpt(sck);
            listener.onLog(Ftil.fff("TCP CONNECTED %s<%s", this.getSckLocal(), this.getSckRemote()));
        }
        catch (IOException e) {
            listener.onLog(Ftil.fff("TCP %s LISTEN ERROR %s", this.getPort(), e.getMessage()));
        }
        catch (Exception e) {
            logger.e(e);
        }
        finally {
            this.closeServerSck();
        }
        return this.getSocket();
    }

    private void closeServerSck() {
        try {
            if (null != this.ss) {
                this.ss.close();
            }
        }
        catch (Exception e) {
            logger.w(e.getMessage());
        }
    }

    public Socket tryConnect(TcpLogListener listener) {
        this.assertNotContd();
        try {
            Socket sck = new Socket();
            listener.onLog(Ftil.fff("TCP CONNECTING %s", this.ipClient()));
            sck.connect(this.ipClient(), 10000);
            this.defSckOpt(sck);
            listener.onLog(Ftil.fff("TCP CONNECTED %s>%s", this.getSckRemote(), this.getSckLocal()));
        }
        catch (IOException e) {
            listener.onLog(Ftil.fff("TCP %s CONNECT ERROR %s", this.ipClient(), e.getMessage()));
        }
        catch (Exception e) {
            logger.e(e);
        }
        return this.getSocket();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void defSckOpt(Socket sck) throws IOException {
        this.socket = sck;
        if (null == sck) {
            return;
        }
        sck.setTcpNoDelay(true);
        this.dis = new DataInputStream(sck.getInputStream());
        this.dos = new DataOutputStream(sck.getOutputStream());
    }

    public byte read() throws IOException {
        this.assertContd();
        return this.dis.readByte();
    }

    public int readBeInt() throws IOException {
        this.assertContd();
        return this.dis.readInt();
    }

    public byte[] readUntil(byte b) throws IOException {
        byte _1;
        MemoryBuffer mb = new MemoryBuffer(256);
        do {
            _1 = this.read();
            mb.append(_1);
        } while (_1 != b);
        return mb.toBytes();
    }

    public byte[] read(int size) throws IOException {
        this.assertContd();
        byte[] bs = new byte[size];
        this.dis.readFully(bs);
        return bs;
    }

    public String readAscii(int size) throws IOException {
        return new String(this.read(size));
    }

    public String readAscii(int size, String charset) throws IOException {
        return new String(this.read(size), charset);
    }

    public boolean writeBeInt(int i) throws IOException {
        this.assertContd();
        this.dos.writeInt(i);
        this.dos.flush();
        return true;
    }

    public boolean write(byte[] bs) throws IOException {
        this.assertContd();
        this.dos.write(bs);
        this.dos.flush();
        return true;
    }

    public boolean write(int i, byte[] bs) throws IOException {
        this.assertContd();
        this.dos.writeInt(i);
        this.dos.write(bs);
        this.dos.flush();
        return true;
    }

    private void assertContd() throws IOException {
        if (this.isConnected()) {
            return;
        }
        String s = Ftil.fff("Not connected (%s/%d)", this.getIpAddress(), this.getPort());
        throw new IOException(s);
    }

    private void assertNotContd() {
        Assert.isFalse(this.isConnected(), "Already connected (%s/%d)", this.getIpAddress(), this.getPort());
        Assert.isFalse(0 == this.getPort(), "Tcp port is 0", new Object[0]);
    }

    public void close() {
        try {
            this.closeServerSck();
            TcpUtils.quietClose(this.getSocket());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTimeout(int millis) {
        TcpUtils.quietSetTimeout(this.getSocket(), millis);
    }
}

