/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import kr.floware.socket.TcpUtils;
import kr.floware.utils.Assert;
import kr.floware.utils.MemoryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpSocket {
    private static final int SEC_1 = 1000;
    private static final int SECOND_10 = 10000;
    static Logger logger = LoggerFactory.getLogger(TcpSocket.class);
    private DataInputStream dis;
    private DataOutputStream dos;
    private String ipAddress = "127.0.0.1";
    private int port = 0;
    Socket socket;

    public String getSckRemote() {
        return null == this.getSocket() ? "" : this.getSocket().getRemoteSocketAddress().toString();
    }

    public String getSckLocal() {
        return null == this.getSocket() ? "" : this.getSocket().getLocalSocketAddress().toString();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    private SocketAddress ipClient() {
        InetSocketAddress isa = new InetSocketAddress(this.getIpAddress(), this.getPort());
        return isa;
    }

    public boolean isConnected() {
        if (null == this.getSocket()) {
            return false;
        }
        return this.getSocket().isConnected() && !this.getSocket().isClosed() && !this.getSocket().isInputShutdown() && !this.getSocket().isOutputShutdown();
    }

    public Socket tryConnect(String id) {
        logger = LoggerFactory.getLogger((String)id);
        this.assertNotContd();
        try {
            Socket sck = new Socket();
            logger.info(String.format("TCP CONNECTING %s", this.ipClient()));
            sck.connect(this.ipClient(), 10000);
            this.defSckOpt(sck);
            logger.info(String.format("TCP CONNECTED %s>%s", this.getSckRemote(), this.getSckLocal()));
        }
        catch (IOException e) {
            logger.info(String.format("TCP %s CONNECT ERROR %s", this.ipClient(), e.getMessage()));
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        return this.getSocket();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void defSckOpt(Socket sck) throws IOException {
        this.socket = sck;
        if (null == sck) {
            return;
        }
        sck.setTcpNoDelay(true);
        this.dis = new DataInputStream(sck.getInputStream());
        this.dos = new DataOutputStream(sck.getOutputStream());
    }

    public byte read() throws IOException {
        this.assertContd();
        return this.dis.readByte();
    }

    public int readBeInt() throws IOException {
        this.assertContd();
        return this.dis.readInt();
    }

    public byte[] read(int size) throws IOException {
        this.assertContd();
        byte[] bs = new byte[size];
        this.dis.readFully(bs);
        return bs;
    }

    public byte[] readTo(byte etx) throws IOException {
        byte b;
        this.assertContd();
        MemoryBuffer mb = new MemoryBuffer();
        do {
            b = this.dis.readByte();
            mb.append(b);
        } while (b != etx);
        return mb.toBytes();
    }

    public boolean send(byte[] bs) throws IOException {
        this.assertContd();
        this.dos.write(bs);
        this.dos.flush();
        return true;
    }

    private void assertContd() throws IOException {
        if (this.isConnected()) {
            return;
        }
        String s = String.format("Not connected (%s/%d)", this.getIpAddress(), this.getPort());
        throw new IOException(s);
    }

    private void assertNotContd() {
        Assert.isTrue(!this.isConnected(), String.format("Already connected (%s/%d)", this.getIpAddress(), this.getPort()), new Object[0]);
        Assert.isTrue(0 != this.getPort(), "Tcp port is 0", new Object[0]);
    }

    public void close() {
        try {
            TcpUtils.quietClose(this.getSocket());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTimeout(int millis) {
        TcpUtils.quietSetTimeout(this.getSocket(), millis);
    }
}

