/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import kr.floware.utils.Assert;

public class BitUtils {
    public static byte[] middle2(byte ... bs) {
        for (int i = 0; i < bs.length; i += 2) {
            BitUtils.reverse2(bs, i, 2);
        }
        return bs;
    }

    private static void reverse2(byte[] bs, int index, int length) {
        byte[] cp = new byte[length];
        System.arraycopy(bs, index, cp, 0, length);
        byte[] rev = BitUtils.reverse(cp);
        System.arraycopy(rev, 0, bs, index, length);
    }

    private static final byte long7(long l) {
        return (byte)(l >>> 56);
    }

    private static final byte long6(long l) {
        return (byte)(l >>> 48);
    }

    private static final byte long5(long l) {
        return (byte)(l >>> 40);
    }

    private static final byte long4(long l) {
        return (byte)(l >>> 32);
    }

    private static final byte long3(long l) {
        return (byte)(l >>> 24);
    }

    private static final byte long2(long l) {
        return (byte)(l >>> 16);
    }

    private static final byte long1(long l) {
        return (byte)(l >>> 8);
    }

    private static final byte long0(long l) {
        return (byte)(l >>> 0);
    }

    private static final byte int3(int i) {
        return (byte)(i >>> 24);
    }

    private static final byte int2(int i) {
        return (byte)(i >>> 16);
    }

    private static final byte int1(int i) {
        return (byte)(i >>> 8);
    }

    private static final byte int0(int i) {
        return (byte)(i >>> 0);
    }

    public static byte[] arraycopy(byte[] src) {
        int length = src.length;
        byte[] dest = new byte[length];
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static int swap(int x) {
        return BitUtils.swap((short)x) << 16 | BitUtils.swap((short)(x >> 16)) & 0xFFFF;
    }

    public static long swap(long x) {
        return (long)BitUtils.swap((int)x) << 32 | (long)BitUtils.swap((int)(x >> 32)) & 0xFFFFFFFFL;
    }

    public static boolean getBoolean(byte b) {
        return b != 0;
    }

    public static byte putBoolean(boolean bool) {
        return bool ? (byte)1 : 0;
    }

    public static char getChar(byte[] bs) {
        Assert.isTrue(2 == bs.length, "Only support 2 bytes", new Object[0]);
        int i = bs[0] & 0xFF;
        int j = bs[1] & 0xFF;
        return (char)(i << 8 | j << 0);
    }

    public static byte[] putChar(char c) {
        byte[] bs = new byte[]{(byte)(c >>> 8), (byte)(c >>> 0)};
        return bs;
    }

    public static int getUshort(byte[] bs) {
        Assert.isTrue(2 == bs.length, "Only support 2 bytes", new Object[0]);
        int i = bs[0] & 0xFF;
        int j = bs[1] & 0xFF;
        return i << 8 | j << 0;
    }

    public static byte[] putUshort(int i) {
        Assert.isTrue(i < 65536 && i > -1, "Only support 0~65535", new Object[0]);
        byte[] bs = new byte[]{BitUtils.int1(i), BitUtils.int0(i)};
        return bs;
    }

    public static short getShort(byte[] bs) {
        Assert.isTrue(2 == bs.length, "Only support 2 bytes", new Object[0]);
        int i = bs[0] & 0xFF;
        int j = bs[1] & 0xFF;
        return (short)(i << 8 | j << 0);
    }

    public static byte[] putShort(int i) {
        Assert.isTrue(i >= Short.MIN_VALUE && i <= Short.MAX_VALUE, "Only support -32768~32767", new Object[0]);
        return BitUtils.putShort((short)i);
    }

    public static byte[] putShort(short s) {
        byte[] bs = new byte[]{(byte)(s >>> 8), (byte)(s >>> 0)};
        return bs;
    }

    public static int getInt(byte[] bs) {
        Assert.isTrue(4 == bs.length, "Only support 4 bytes", new Object[0]);
        int i = bs[0] & 0xFF;
        int j = bs[1] & 0xFF;
        int k = bs[2] & 0xFF;
        int l = bs[3] & 0xFF;
        return i << 24 | j << 16 | k << 8 | l << 0;
    }

    public static byte[] putInt(int i) {
        byte[] bs = new byte[]{BitUtils.int3(i), BitUtils.int2(i), BitUtils.int1(i), BitUtils.int0(i)};
        return bs;
    }

    public static long getLong(byte[] bs) {
        Assert.isTrue(8 == bs.length, "Only support 8 bytes", new Object[0]);
        long a = (long)bs[0] & 0xFFL;
        long b = (long)bs[1] & 0xFFL;
        long c = (long)bs[2] & 0xFFL;
        long d = (long)bs[3] & 0xFFL;
        long e = (long)bs[4] & 0xFFL;
        long f = (long)bs[5] & 0xFFL;
        long g = (long)bs[6] & 0xFFL;
        long h = (long)bs[7] & 0xFFL;
        return a << 56 | b << 48 | c << 40 | d << 32 | e << 24 | f << 16 | g << 8 | h << 0;
    }

    public static byte[] putLong(long l) {
        byte[] bs = new byte[]{BitUtils.long7(l), BitUtils.long6(l), BitUtils.long5(l), BitUtils.long4(l), BitUtils.long3(l), BitUtils.long2(l), BitUtils.long1(l), BitUtils.long0(l)};
        return bs;
    }

    public static float getFloat(byte[] bs) {
        int i = BitUtils.getInt(bs);
        return Float.intBitsToFloat(i);
    }

    public static byte[] putFloat(float f) {
        int i = Float.floatToIntBits(f);
        return BitUtils.putInt(i);
    }

    public static double getDouble(byte[] bs) {
        long l = BitUtils.getLong(bs);
        return Double.longBitsToDouble(l);
    }

    public static byte[] putDouble(double d) {
        long l = Double.doubleToLongBits(d);
        return BitUtils.putLong(l);
    }

    public static byte[] reverse(byte ... bs) {
        byte[] bb = new byte[bs.length];
        for (int i = 0; i < bb.length; ++i) {
            bb[bb.length - 1 - i] = bs[i];
        }
        return bb;
    }
}

