/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.floware.DateTime;
import kr.floware.utils.Assert;
import kr.floware.utils.MethodInvoker;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new HashMap(8);
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(8);
    private static FieldFilter COPYABLE_FIELDS;

    public static boolean isAssignable(Class<?> targetType, Class<?> valueType) {
        Assert.notNull(targetType, "Class must not be null", new Object[0]);
        Assert.notNull(valueType, "Class must not be null", new Object[0]);
        return targetType.isAssignableFrom(valueType) || targetType.equals(primitiveWrapperTypeMap.get(valueType));
    }

    public static boolean isAssignableValue(Class<?> clazz, Object value) {
        Assert.notNull(clazz, "Type must not be null", new Object[0]);
        return value != null ? ClassUtils.isAssignable(clazz, value.getClass()) : !clazz.isPrimitive();
    }

    public static void valueCopy(Object source, Object dest) {
        List<Method> destMethods = ClassUtils.getAllDeclaredMethodList(dest.getClass());
        Class<?> sourceClazz = source.getClass();
        for (Method destMethod : destMethods) {
            Object sourceValue;
            if (ClassUtils.isHashCodeMethod(destMethod) || ClassUtils.isEqualsMethod(destMethod) || ClassUtils.isGetClassMethod(destMethod) || ClassUtils.isToStringMethod(destMethod) || !destMethod.getName().startsWith("set")) continue;
            String name = destMethod.getName().substring(3);
            Method sourceMethod = ClassUtils.findMethod(sourceClazz, "get" + name, new Class[0]);
            if (null == sourceMethod || null == (sourceValue = ClassUtils.invoke(source, sourceMethod, source))) continue;
            ClassUtils.invoke(dest, destMethod, sourceValue);
        }
    }

    public static String toString(Object object) {
        Method[] methods;
        StringBuffer sb = new StringBuffer(256);
        Class<?> clazz = object.getClass();
        sb.append(clazz.getSimpleName());
        for (Method method : methods = ClassUtils.getAllDeclaredMethods(clazz)) {
            String methodName;
            if (!ClassUtils.isPublicMethod(method) || ClassUtils.isGetClassMethod(method) || 0 != method.getParameterTypes().length || !(methodName = method.getName()).startsWith("get") && !methodName.startsWith("is")) continue;
            sb.append(" ");
            int idx = methodName.startsWith("is") ? 2 : 3;
            String name = method.getName().substring(idx);
            Object value = ClassUtils.invoke(object, method);
            if (value instanceof Date) {
                Date date = (Date)value;
                value = DateTime.from(date).toString();
            }
            sb.append(String.format("%s=%s", name, value));
        }
        return sb.toString();
    }

    public static boolean isPublicMethod(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    public static Field[] getAllDeclaredFields(Class<?> leafClass) {
        return leafClass.getDeclaredFields();
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) throws IllegalArgumentException {
        List<Method> list = ClassUtils.getAllDeclaredMethodList(leafClass);
        return list.toArray(new Method[list.size()]);
    }

    public static List<Method> getAllDeclaredMethodList(Class<?> leafClass) throws IllegalArgumentException {
        final ArrayList<Method> list = new ArrayList<Method>(32);
        ClassUtils.doWithMethods(leafClass, new MethodCallback(){

            @Override
            public void doWith(Method method) {
                list.add(method);
            }
        });
        return list;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "class is null", new Object[0]);
        Assert.notNull(name, "method name is null", new Object[0]);
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    public static Object invoke(Object target, String methodName, Object ... args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        MethodInvoker methodInvoker = new MethodInvoker();
        methodInvoker.setTargetObject(target);
        methodInvoker.setTargetMethod(methodName);
        methodInvoker.setArguments(args);
        methodInvoker.prepare();
        return methodInvoker.invoke();
    }

    public static Object invoke(Object target, Method method) {
        return ClassUtils.invoke(target, method, new Object[0]);
    }

    public static Object invoke(Object target, Method method, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ClassUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    static Field findField(Class<?> clazz, String name) {
        return ClassUtils.findField(clazz, name, null);
    }

    private static Field findField(Class<?> clazz, String name, Class<?> type) {
        Assert.notNull(clazz, "class must not be null", new Object[0]);
        Assert.notNull(name, "name is null", new Object[0]);
        Assert.notNull(type, "type is null", new Object[0]);
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields = searchType.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            ClassUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    static Object getField(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            ClassUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    private static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ClassUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        ClassUtils.handleUnexpectedException(ex);
    }

    private static void handleInvocationTargetException(InvocationTargetException ex) {
        ClassUtils.rethrowRuntimeException(ex.getTargetException());
    }

    private static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        ClassUtils.handleUnexpectedException(ex);
    }

    static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        ClassUtils.handleUnexpectedException(ex);
    }

    private static void handleUnexpectedException(Throwable ex) {
        IllegalStateException isex = new IllegalStateException("Unexpected exception thrown");
        isex.initCause(ex);
        throw isex;
    }

    static boolean declaresException(Method method, Class<?> exceptionType) {
        Assert.notNull(method, "method must not be null", new Object[0]);
        Class<?>[] declaredExceptions = method.getExceptionTypes();
        for (int i = 0; i < declaredExceptions.length; ++i) {
            Class<?> declaredException = declaredExceptions[i];
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isGetClassMethod(Method method) {
        return method != null && method.getName().equals("getClass") && method.getParameterTypes().length == 0;
    }

    static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    private static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    static void makeAccessible(Method method) {
        if (!ClassUtils.isPublicMethod(method) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
    }

    static void makeAccessible(Constructor<Object> ctor) {
        if (!Modifier.isPublic(ctor.getModifiers()) || !Modifier.isPublic(ctor.getDeclaringClass().getModifiers())) {
            ctor.setAccessible(true);
        }
    }

    static void doWithMethods(Class<?> targetClass, MethodCallback mc) throws IllegalArgumentException {
        ClassUtils.doWithMethods(targetClass, mc, null);
    }

    private static void doWithMethods(Class<?> targetClass, MethodCallback mc, MethodFilter mf) throws IllegalArgumentException {
        do {
            Method[] methods = targetClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (mf != null && !mf.matches(methods[i])) continue;
                try {
                    mc.doWith(methods[i]);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + methods[i].getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null);
    }

    static void doWithFields(Class<?> targetClass, FieldCallback fc) throws IllegalArgumentException {
        ClassUtils.doWithFields(targetClass, fc, null);
    }

    private static void doWithFields(Class<?> targetClass, FieldCallback fc, FieldFilter ff) throws IllegalArgumentException {
        do {
            Field[] fields = targetClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (ff != null && !ff.matches(fields[i])) continue;
                try {
                    fc.doWith(fields[i]);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + fields[i].getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    static void shallowCopyFieldState(final Object src, final Object dest) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ClassUtils.doWithFields(src.getClass(), new FieldCallback(){

            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ClassUtils.makeAccessible(field);
                Object srcValue = field.get(src);
                field.set(dest, srcValue);
            }
        }, COPYABLE_FIELDS);
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return ClassUtils.forName(name, ClassUtils.getDefaultClassLoader());
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassUtils.class.getClassLoader();
        }
        return cl;
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        return Class.forName(name, true, classLoader);
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = primitiveTypeNameMap.get(name);
        }
        return result;
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        for (Class<?> primitiveClass : primitiveWrapperTypeMap.values()) {
            primitiveTypeNameMap.put(primitiveClass.getName(), primitiveClass);
        }
        COPYABLE_FIELDS = new FieldFilter(){

            @Override
            public boolean matches(Field field) {
                return !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
            }
        };
    }

    private static interface FieldFilter {
        public boolean matches(Field var1);
    }

    private static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    private static interface MethodFilter {
        public boolean matches(Method var1);
    }

    private static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

