/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import kr.floware.Ftil;

public class DateUtils {
    public static final String DEFAULTFORMAT = "yyyyMMddHHmmssSSS";
    public static final SimpleDateFormat DEFAULTSDF = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    public static final SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("MM");
    public static final SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("dd");

    public static String getTime(SimpleDateFormat sdf, Date date) {
        return sdf.format(date);
    }

    public static String getTime(String format, Date date) {
        return DateUtils.getDateFormat(format).format(date);
    }

    public static SimpleDateFormat getDateFormat(String format) {
        return new SimpleDateFormat(format);
    }

    public static String getTime(String format) {
        return DateUtils.getTime(new SimpleDateFormat(format));
    }

    public static String getTime(SimpleDateFormat sdf) {
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    public static String getTime(Date date) {
        return DEFAULTSDF.format(date);
    }

    public static String getTime(long millis) {
        return DEFAULTSDF.format(new Date(millis));
    }

    public static String getTime() {
        return DEFAULTSDF.format(new Date());
    }

    public static int getMonth() {
        return Ftil.toInt(MONTH_FORMAT.format(new Date(System.currentTimeMillis())));
    }

    public static int getDay(Date date) {
        return Ftil.toInt(DAY_FORMAT.format(date));
    }

    public static int getDay() {
        return DateUtils.getDay(new Date());
    }

    public static Date addSeconds(int second) {
        return DateUtils.addDate(new Date(), second, 1000L);
    }

    public static Date addMinutes(int minute) {
        return DateUtils.addDate(new Date(), minute, 60000L);
    }

    public static Date addHours(int hour) {
        return DateUtils.addHours(new Date(), hour);
    }

    public static Date addHours(Date date, int hour) {
        return DateUtils.addDate(date, hour, 3600000L);
    }

    public static Date addDays(int day) {
        return DateUtils.addDays(new Date(), day);
    }

    public static Date addDays(Date date, int day) {
        return DateUtils.addDate(date, day, 86400000L);
    }

    private static Date addDate(Date date, int i, long offset) {
        long l = date.getTime();
        return new Date(l += offset * (long)i);
    }
}

