/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class JvmUtils {
    public static String platform() {
        return String.format("%s:%s", System.getProperty("os.name"), System.getProperty("os.arch"));
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "Unk HostName";
        }
    }

    public static String version() {
        return System.getProperty("java.version");
    }

    public static String vendor() {
        return System.getProperty("java.vendor");
    }

    public static String jvm() {
        return System.getProperty("java.vm.name");
    }

    public static int threadCount() {
        return Thread.activeCount();
    }

    public static long memTotal() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    public static long memFree() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    public static long memMax() {
        return Runtime.getRuntime().maxMemory() / 0x100000L;
    }

    public static long memUse() {
        return JvmUtils.memTotal() - JvmUtils.memFree();
    }
}

