/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kr.floware.logging.Logger;
import kr.floware.utils.Assert;
import kr.floware.utils.BitUtils;
import kr.floware.utils.StringUtils;

public class MemoryBuffer {
    private static Logger logger = Logger.getLogger();
    private ByteBuffer bb;
    int mark = -1;

    public MemoryBuffer() {
        this(1024);
    }

    public void append(int ... is) {
        byte[] bs = new byte[is.length];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)is[i];
        }
        this.append(bs);
    }

    public void appendLeShort(int i) {
        byte[] bs = BitUtils.putShort(i);
        this.append(BitUtils.reverse(bs));
    }

    public void appendLeUshort(int i) {
        byte[] bs = BitUtils.putUshort(i);
        this.append(BitUtils.reverse(bs));
    }

    public synchronized int readLeShort() {
        return BitUtils.getShort(BitUtils.reverse(this.read(2)));
    }

    public MemoryBuffer(int capa) {
        this.bb = ByteBuffer.allocate(capa);
    }

    public void append(byte ... bs) {
        this.append(bs, 0, bs.length);
    }

    public void appendBeInt(int i) {
        byte[] bs = BitUtils.putInt(i);
        this.append(bs);
    }

    public void appendBeShort(int i) {
        this.bb.putShort((short)i);
    }

    public void appendLeInt(int i) {
        byte[] bs = BitUtils.putInt(i);
        this.append(BitUtils.reverse(bs));
    }

    public void appendAscii(int length, String s) {
        this.appendAscii(length, s, Charset.defaultCharset().toString());
    }

    public void appendAscii(int length, String s, String charsetName) {
        byte[] bs = new byte[length];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = 32;
        }
        try {
            byte[] bs1 = s.getBytes(charsetName);
            int min = Math.min(bs1.length, length);
            System.arraycopy(bs1, 0, bs, 0, min);
        }
        catch (UnsupportedEncodingException e) {
            logger.e(e);
        }
        this.append(bs, 0, length);
    }

    public synchronized void append(byte[] bs, int offset, int length) {
        while (this.bb.remaining() < length) {
            this.expand();
        }
        this.bb.put(bs, offset, length);
    }

    private void expand() {
        this.bb.limit(this.bb.position());
        this.bb.rewind();
        ByteBuffer newbb = ByteBuffer.allocate(this.bb.capacity() * 2);
        newbb.put(this.bb);
        this.bb.clear();
        this.bb = newbb;
    }

    public int getPos() {
        return this.bb.position();
    }

    public synchronized byte[] read(int size) {
        byte[] bs = new byte[size];
        this.bb.get(bs);
        return bs;
    }

    public synchronized void chgPos(int pos) {
        this.bb.position(pos);
    }

    public synchronized int readBeInt() {
        return this.bb.getInt();
    }

    public synchronized int readBeShort() {
        return this.bb.getShort();
    }

    public synchronized int readLeInt() {
        byte[] bs = this.read(4);
        return BitUtils.getInt(BitUtils.reverse(bs));
    }

    public String readAscii(int size) {
        return this.readAscii(size, Charset.defaultCharset().toString());
    }

    public String readAscii(int size, String charsetName) {
        byte[] bs = this.read(size);
        for (int i = 0; i < bs.length; ++i) {
            if (bs[i] != 0) continue;
            bs[i] = 32;
        }
        try {
            return new String(bs, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bs);
        }
    }

    public void markMove() {
        Assert.isTrue(this.mark >= 0, "mark not set", new Object[0]);
        this.chgPos(this.mark);
    }

    public void mark() {
        this.mark = this.getPos();
    }

    public void zero() {
        this.chgPos(0);
    }

    public void rewind() {
        this.bb.rewind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] toBytes() {
        byte[] bs = new byte[this.length()];
        int curr = this.getPos();
        try {
            this.zero();
            this.bb.get(bs);
            byte[] byArray = bs;
            return byArray;
        }
        finally {
            this.chgPos(curr);
        }
    }

    public String toHex() {
        return StringUtils.toHex2String(this.toBytes());
    }

    public synchronized int length() {
        return this.bb.capacity() - this.bb.remaining();
    }
}

