/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kr.floware.utils.LamUtils;

public class NetUtils {
    public static List<String> listMacAddr() {
        CopyOnWriteArrayList<String> ll = LamUtils.newList();
        try {
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                if (mac == null || mac.length != 6) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                ll.add(sb.toString());
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return ll;
    }
}

